//PlagScan API usage example in JAVA
// REQUIRES httpcomponents-client-4.5.3 lib AND java-json lib
//Make sure to change access_token variable
//METHOD CHECK
package api.code.example;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;


public class Check {
    static private String url = "https://api.plagscan.com/v3/documents/";
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws IOException, URISyntaxException, JSONException {
        /*
        / CHANGE THE access_token AND $docID VARIABLE WITH YOUR OWN TO GET ACCESS TO YOUR DATA
        */
        String access_token = "";
        String docID="";

        //Create the client to make the request
        CloseableHttpClient client = HttpClients.createDefault();
        //Create the request method with the url
        /*
        ****** MUST ADD THE ID OF THE DOCUMENT TO THE URL AND ADD "/check" ******
        */
        HttpPut request = new HttpPut(url+docID+"/check");

        //Adding to the URL the parameters (because it is a GET request)
        URI uri = new URIBuilder(request.getURI())
                .addParameter("access_token", access_token)
                .build();
        ((HttpRequestBase ) request).setURI(uri);

        //Execute the request and get response
        CloseableHttpResponse response = client.execute(request);

        try{
          HttpEntity entity = response.getEntity();
          if(entity != null){
            String strResponse = EntityUtils.toString(entity);
            //We can show the response string directly
            System.out.println(strResponse);
          }
        }finally{
          response.close();
        }

    }
}
