//PlagScan API usage example in JAVA
// REQUIRES httpcomponents-client-4.5.3 lib AND java-json lib
//Make sure to change access_token variable
//METHOD LIST USER
package api.code.example;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;



public class ListUser {

    static private String url = "https://api.plagscan.com/v3/users";
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws IOException, URISyntaxException, JSONException {
        /*
        / CHANGE THE access_token VARIABLE WITH YOUR OWN ACCESS TOKEN TO GET ACCESS TO YOUR DATA
        */
        String access_token = "";

        //Create the client to make the request
        CloseableHttpClient client = HttpClients.createDefault();
        //Create the request method with the url
        HttpGet request = new HttpGet(url);

        //Adding to the URL the parameters (because it is a GET request)
        URI uri = new URIBuilder(request.getURI()).addParameter("access_token", access_token)
                .build();
        ((HttpRequestBase ) request).setURI(uri);

        //Execute the request and get response
        CloseableHttpResponse response = client.execute(request);

        try{
          HttpEntity entity = response.getEntity();
          if(entity != null){
            String strResponse = EntityUtils.toString(entity);
            //We can show the response string directly
            System.out.println(strResponse);

            //Also we can get the JSON object and the array of data that is within it
            JSONObject json = new JSONObject(strResponse);
            JSONArray array = json.getJSONArray("data");
            //Get every user in the array and show the username
            for(int i=0;i<array.length();i++){
                System.out.println("User "+i+": ");
                JSONObject user = array.getJSONObject(i);
                System.out.println(user.get("username"));
            }
          }
        }finally{
          response.close();
        }

    }

}
