//PlagScan API usage example in JAVA
// REQUIRES httpcomponents-client-4.5.3 lib AND java-json lib
//Make sure to change access_token variable
//METHOD SUBMIT DOCUMENT
package api.code.example;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;


public class Submit {
    static private String url = "https://api.plagscan.com/v3/documents";
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws IOException, URISyntaxException, JSONException {
        /*
        / CHANGE THE access_token VARIABLE WITH YOUR OWN TO GET ACCESS TO YOUR DATA
        */
        String access_token = "";

        //Create the client to make the request
        CloseableHttpClient client = HttpClients.createDefault();
        //Create the request method with the url
        HttpPost request = new HttpPost(url);

        //Adding the parameters
        HttpEntity reqEntity = MultipartEntityBuilder.create()
                .addBinaryBody("fileUpload", new File("./testfile.txt"))
                .build();

        request.setEntity(reqEntity);

        //Adding to the URL the parameters (because it is a GET request)
        URI uri = new URIBuilder(request.getURI())
                .addParameter("access_token", access_token)
                .build();
        ((HttpRequestBase ) request).setURI(uri);

        //Execute the request and get response
        CloseableHttpResponse response = client.execute(request);

        try{
          HttpEntity entity = response.getEntity();
          if(entity != null){
            String strResponse = EntityUtils.toString(entity);
            //We can show the response string directly
            System.out.println(strResponse);
            //Also we can get the JSON object
            JSONObject json = new JSONObject(strResponse);
          }
        }finally{
          response.close();
        }

    }
}
