//PlagScan API usage example in JAVA
// REQUIRES httpcomponents-client-4.5.3 lib AND java-json lib
//Make sure to change access_token variable
//METHOD GET ACCESS TOKEN
package api.code.example;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;


public class GetAccessToken {
    static private String url = "https://api.plagscan.com/v3/token";
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws IOException, URISyntaxException, JSONException {
        /*
        / CHANGE THE client_id AND client_secret VARIABLE WITH YOUR OWN TO GET ACCESS TO YOUR DATA
        */
        String client_id = "";
        String client_secret = "";

        //Create the client to make the request
        CloseableHttpClient client = HttpClients.createDefault();
        //Create the request method with the url
        HttpPost request = new HttpPost(url);

        //Adding the parameters
        List<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add(new BasicNameValuePair("client_id", client_id));
        params.add(new BasicNameValuePair("client_secret", client_secret));
        request.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));


        //Execute the request and get response
        CloseableHttpResponse response = client.execute(request);

        try{
          HttpEntity entity = response.getEntity();
          if(entity != null){
            String strResponse = EntityUtils.toString(entity);
            //We can show the response string directly
            System.out.println(strResponse);
            //Also we can get the JSON object and save the access token
            JSONObject json = new JSONObject(strResponse);
            String access_token = json.getString("access_token");
            System.out.println(access_token);
          }
        }finally{
          response.close();
        }

    }
}
