<?php
//PlagScan API usage example in PHP (requires PHP 5 or higher)
// and REQUIRES Guzzle http://docs.guzzlephp.org
//Make sure to change access_token variable
//METHOD SUBMIT DOCUMENT

//Require composer's autoloader to use Guzzle
require 'vendor/autoload.php';
use GuzzleHttp\Client;


// Submit those variables to the server
$post_data = array(
  array(
    "name" => "fileUpload",
    "contents" => fopen("./testfile.txt", "r")
  )
);

$client = new Client([
  "base_uri" => "https://api.plagscan.com/v3/",
  ///////////////////////////////////// HERE CHANGE THE TIMEOUT, COULD HAPPENS THAT SPEND MORE TIME
  "timeout" => 20.0,
  "http_errors" => false
]);

$response = $client->post("documents?access_token=ca31ca2e74c84512a8554a069b0f985068804b05", [ "multipart" => $post_data]);

if($response->getStatusCode() == 201){
  $content = json_decode($response->getBody(), true);
  $data = $content["data"];

  echo "ID: ".$data["docID"]."\n";
  echo "Location: ".$content["location"]."\n";
}
else {
  echo $response->getBody();
}
