<?php
//PlagScan API usage example in PHP (requires PHP 5 or higher)
// and REQUIRES Guzzle http://docs.guzzlephp.org
//Make sure to change access_token variable
//METHOD ADD USER

//Require composer's autoloader to use Guzzle
require 'vendor/autoload.php';
use GuzzleHttp\Client;


// Submit those variables to the server
$post_data = array(
    	"access_token"=> "ca31ca2e74c84512a8554a069b0f985068804b05",
      "email" => "codeexample@plagscan.com",
      "username" => "codeexample",
      "firstname" => "code",
      "lastname" => "example"
);

$client = new Client([
  "base_uri" => "https://api.plagscan.com/v3/",
  "timeout" => 2.0,
  "http_errors" => false
]);

$response = $client->post("users", [ "form_params" => $post_data]);

if($response->getStatusCode() == 201){
  $content = json_decode($response->getBody(), true);
  $data = $content["data"];

  echo "ID: ".$data["internalID"]."\n";
  echo "Location: ".$content["location"]."\n";

  //Using the location you can access to the new created user information
  $post_data = array(
      	"access_token"=> "ca31ca2e74c84512a8554a069b0f985068804b05"
  );
  $response = $client->get($content["location"], [ "query" => $post_data]);

  echo "\n\n Getting the created user information...\n";
  echo $response->getBody();
}
else {
  echo $response->getBody();
}
